// Object identifier "OVLY"
#define IDENTIFIER	0x4F564C59

// ------------------------------
// DEFINITION OF CONDITIONS CODES
// ------------------------------
#define	CND_MATCH					0
#define CND_MATCHRGB				1
#define CND_OUTSIDE					2
#define CND_DEBUGON					3
#define CND_RANGERGB				4
#define CND_FADE_DONE				5
#define CND_FADING					6
#define	CND_LAST					7

// ---------------------------
// DEFINITION OF ACTIONS CODES
// ---------------------------
#define ACT_DEBUGON					0
#define ACT_DEBUGOFF				1

#define ACT_CLEAR					2
#define ACT_REPLACE					3
#define	ACT_PIXEL					4
#define ACT_LINE					5
#define ACT_RECTANGLE				6
#define ACT_CIRCLE					7

#define ACT_CLEARRGB				8
#define ACT_REPLACERGB				9
#define	ACT_PIXELRGB				10
#define ACT_LINERGB					11
#define ACT_RECTANGLERGB			12
#define ACT_CIRCLERGB				13

#define ACT_LOADBMP					14

#define ACT_STRETCHON    			15
#define ACT_STRETCHOFF				16

#define ACT_FILL					17
#define ACT_FILLRGB					18

#define ACT_SAVEBMP					19

#define ACT_SET_POS					20
#define ACT_SET_XPOS				21
#define ACT_SET_YPOS				22

#define ACT_AUTOON					23
#define ACT_AUTOOFF					24

#define ACT_IMMEDIATEON				25
#define ACT_IMMEDIATEOFF			26

#define ACT_ABSOLUTEON				27
#define ACT_ABSOLUTEOFF				28

#define ACT_MODEOPAQUE				29
#define ACT_MODETRANSP				30

#define ACT_UPDATE					31

#define ACT_CLEARNEW				32
#define ACT_REPLACENEW				33
#define	ACT_PIXELNEW				34
#define ACT_LINENEW					35
#define ACT_RECTANGLENEW			36
#define ACT_CIRCLENEW				37
#define ACT_FILLNEW					38
#define ACT_POLYGON					39

#define ACT_RESIZE					40

#define ACT_ADDPOINT				41
#define ACT_PLOTPOLY				42
#define ACT_CLEARPTS				43

#define ACT_PASTEOBJ				44

#define ACT_KEEPPTSON				45
#define ACT_KEEPPTSOFF				46

#define ACT_INK_NONE				47
#define ACT_INK_SEMI				48
#define ACT_INK_INVERT				49
#define ACT_INK_XOR					50
#define ACT_INK_AND					51
#define ACT_INK_OR					52
#define ACT_INK_ANDNOT				53

#define ACT_ANTIAON					54
#define ACT_ANTIAOFF				55

#define ACT_SETINK					56
#define ACT_AUTOINK					57
#define ACT_STOPINK					58
#define ACT_REVINK					59
#define ACT_SETEFFECT				60

#define ACT_SHAPE					61
#define ACT_PLOTSHAPE				62

#define ACT_PASTEOVERLAY			63
#define ACT_DRAWSTRING              64
#define	ACT_LAST					65

// -------------------------------
// DEFINITION OF EXPRESSIONS CODES
// -------------------------------
#define	EXP_GETRED					0
#define	EXP_GETGREEN				1
#define	EXP_GETBLUE					2
#define EXP_GETCOLOR				3
#define EXP_GETRGB					4
#define EXP_GETXPOS					5
#define EXP_GETYPOS					6
#define EXP_RANGE					7
#define EXP_NOFILL					8
#define EXP_GETWIDTH				9
#define EXP_GETHEIGHT				10
#define EXP_GETINK					11
#define EXP_GETINKSPEED				12
#define EXP_GETEFFECT				13
#define EXP_GETFIXED				14
#define EXP_GETCINDEX				15
#define	EXP_LAST                    16

// --------------------------------
// EDITION OF OBJECT DATA STRUCTURE
// --------------------------------
typedef struct tagEDATA_V0
{
	extHeader		eHeader;
	short			sx;
	short			sy;
	short			swidth;
	short			sheight;
	npAppli			appID;

	WORD			imgidx;
	WORD            nImages;
	UINT			Flags;			//stores flags

	BlitOp			Effect;			//blit effect
	int				EffectParam;	//effect parameter 
	
} EDITDATA;
typedef EDITDATA _far *			LPEDATA;

// Object versions
#define	KCX_CURRENT_VERSION			2

//define Settings Flags (only used at edittime)
#define	OVLFLAG_DEBUG				0x01
#define	OVLFLAG_STRETCH				0x02
#define	OVLFLAG_ABSOLUTE			0x04
#define	OVLFLAG_IMMEDIATE			0x08
#define	OVLFLAG_AUTOMATIC			0x10
#define	OVLFLAG_OPAQUE				0x20
#define	OVLFLAG_ANTIA				0x40
#define	OVLFLAG_KEEPPTS				0x80
#define	OVLFLAG_DEFAULT				OVLFLAG_DEBUG | OVLFLAG_AUTOMATIC | OVLFLAG_OPAQUE

//define interval size of Points array
#define	POINTS_INTERVAL				10

// --------------------------------
// RUNNING OBJECT DATA STRUCTURE
// --------------------------------
typedef struct tagRDATA
{
	headerObject	rHo;					// Header
	rCom			rc;
	rVal			rv;						// Values
	LPSURFACE		runSurface;

	int			X;
	int			Y;
	int			OldX;
	int			OldY;

	short			swidth;
	short			sheight;
	short			oldwidth;		//For stretching
	short			oldheight;		//For stretching
	char			rFilename[_MAX_PATH];

	BOOL			debugmode;		//Is debug mode on? (visibility)
	BOOL            stretching;		//Is stretching on?
	BOOL			AbsolutePos;	//drawing position absolute
	BOOL			Immediate;		//update display immediately
	BOOL			Automatic;		//update display automatically

	BOOL			AntiA;			//anti-aliasing
	BlitMode		Mode;			//display mode (opaque or trans)
	BlitOp			Effect;			//blit effect
	int				EffectParam;	//effect parameter
	DWORD           BlitFlag;
	POINT *			Points;			//points for "Plot Polygon"
	unsigned long	NumPoints;		//number of points to plot
	unsigned long	SizePoints;		//size of array of points
	BOOL			RemovePoints;	//remove points after plotting polygon

	BOOL			Fade;			//true if we should be fading
	float			FadeSpeed;		//speed at which to fade
	float			FadeInk;		//current ink effect param as a float
} RUNDATA;
typedef	RUNDATA	_far *			LPRDATA;

// Size when editing the object under level editor
// -----------------------------------------------
#define	MAX_EDITSIZE			sizeof(EDITDATA)

// Default flags
// -------------
#define	OEFLAGS      			OEFLAG_BACKGROUND|OEFLAG_VALUES|OEFLAG_BACKSAVE
#define	OEPREFS      			OEPREFS_INKEFFECTS|OEPREFS_BACKSAVE

// If to handle message, specify the priority of the handling procedure
// 0= low, 255= very high. You should use 100 as normal.                                                
// --------------------------------------------------------------------
#define	WINDOWPROC_PRIORITY		100

#define HANDLEFUNCTION(x) callRunTimeFunction(x, RFUNCTION_REHANDLE, 0, 0)
#define EFFECT_CODES	8 /*9*/

//Inline functions
inline void UpDisp(LPRDATA rdPtr);
inline void AdjCol(long & pR, long & pG, long & pB);
inline void AdjCol(long & Color);
inline void AdjThick(long & Thick, long Low);
inline void AdjPos(LPRDATA rdPtr, long & X, long & Y);
inline bool FlagOn(UINT Source, UINT Flag);
template<typename T>
inline bool InRange(T Check, T LowBound, T UpBound);
template<typename T>
void Swap(T & One, T & Two);
void SetFlag(UINT & Source, UINT Flag, bool On);
long NumChar(char * Str, char Thing, long Length);
